
<?php session_start(); include('includes/database_connect.php');?>
<?php  if($_SESSION['roles'] != 'admin' && $_SESSION['roles'] != 'homeowner'  ){
    header('location: /stockmanagement/admin/login.php');
}?> 
<!DOCTYPE html>
<html lang="en">
<head>
    <?php 
        include('includes/header.php'); 
        include('includes/displaySuccessErrorSession.php');
    ?>
</head>
<body id="page-top">
      <!-- Page Wrapper -->
  <div id="wrapper">
  <?php include('includes/sidenav.php');  ?>
<!-- Content Wrapper -->
<div id="content-wrapper" class="d-flex flex-column">

    <!-- Main Content -->
    <div id="content">

        <?php include('includes/topnav.php');  ?>
       
        <!-- Begin Page Content -->
        <div class="container-fluid">
            <!-- Page Heading -->
            <div class="d-sm-flex align-items-center justify-content-between mb-4">
                <h1 class="h3 mb-0 text-gray-800">Profile</h1>
            </div>
            <!-- Content Row -->
          
            <div class="row">
                <!-- Area Chart -->
                <div class="col-md-12">
                    <div class="card shadow mb-4">
                        <!-- Card Body -->
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 font-weight-bold text-secondary">User Details</h6>
                            <a class="btn btn-secondary" href="user_add.php">Add User</a>
                        </div>
                        <div class="card-body">
                        <div class="table-responsive">
                                
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>Username</th>
                                            <th style="width:20%">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                            $sql = 'select * from users order by id desc';
                                            $result = $conn->query($sql);

                                            if ($result->num_rows > 0) {
                                                // output data of each row
                                                while($row = $result->fetch_assoc()) { ?>
                                                    <tr>
                                                        <td><?php echo $row['username'] ?></td>
                                                        <td>
                                                            <a href="user_edit.php?id=<?php echo $row['id'] ?>" class="btn btn-sm btn-outline-primary">Edit</a>
                                                            <button class="btn btn-sm btn-outline-danger" data-toggle="modal" data-target="#user_delete_modal" onclick="delete_User('<?php echo $row['username']?>','<?php echo $row['id']?>')">Delete</button>
                                                        </td>
                                                    </tr>
                                             <?php   }
                                              } else { ?>
                                                    <tr>
                                                        <td colspan="6">No Data</td>
                                                    </tr>
                                           <?php }
                                        ?>
                                       
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Content Row -->
        </div>
        <!-- /.container-fluid -->

    </div>
    <!-- End of Main Content -->
    <?php include('includes/footer.php') ?>
</div>
<!-- End of Content Wrapper -->
</div>

<!-- Modal -->
<div class="modal fade" id="user_delete_modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body text-center">
            <h6 id="full_name"></h6>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            <a type="button" class="btn btn-danger" id="delete_user_href">Save changes</a>
        </div>
        </div>
    </div>
</div>
<!-- Scroll to Top Button-->
<a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
</a>
    <?php 
        include('includes/logout_modal.php');
        include('includes/footer_link.php');
        include('includes/unsetSuccessErrorSession.php');
    ?>
    <!-- Page level custom scripts -->
<script src="js/demo/datatables-demo.js"></script>

<script>
    function delete_User(full_name, id) {
        var url = 'api/delete_user.php?id='+id;
        $('#full_name').text('Are you sure want to delete '+full_name+ ' ?');
        $('#delete_user_href').attr('href', url);
    }
</script>
</body>

</html>