
<?php session_start(); include('includes/database_connect.php');?>
<?php  if($_SESSION['roles'] != 'admin' && $_SESSION['roles'] != 'homeowner'  ){
    header('location: ../login.php');
}?> 
<!DOCTYPE html>
<html lang="en">
<head>
    <?php 
        include('includes/header.php'); 
        include('includes/displaySuccessErrorSession.php');
    ?>
</head>
<body id="page-top">
      <!-- Page Wrapper -->
  <div id="wrapper">
  <?php include('includes/sidenav.php');  ?>
<!-- Content Wrapper -->
<div id="content-wrapper" class="d-flex flex-column">

    <!-- Main Content -->
    <div id="content">

        <?php include('includes/topnav.php');  ?>
       
        <!-- Begin Page Content -->
        <div class="container-fluid">
            <!-- Page Heading -->
            <div class="d-sm-flex align-items-center justify-content-between mb-4">
                <h1 class="h3 mb-0 text-gray-800">PPE</h1>
            </div>
            <!-- Content Row -->
          
            <div class="row">
                <!-- Area Chart -->
                <div class="col-md-12">
                    <div class="card shadow mb-4">
                        <!-- Card Body -->
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 font-weight-bold text-secondary">PPE Details</h6>
                            <a class="btn btn-secondary" href="stock_add.php">Add PPE</a>
                        </div>
                        <div class="card-body">
                        <div class="table-responsive">
                                
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                           
                                            <th>Name</th>
                                            <th>Size</th>
                                            <th>Quantity</th>
                                            
                                            <th style="width: 15%;">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                            $sql = 'select * from stocks order by id desc';
                                            $result = $conn->query($sql);

                                            if ($result->num_rows > 0) {
                                                // output data of each row
                                                while($row = $result->fetch_assoc()) { ?>
                                                    <tr>
                                                        
                                                        <td><?= $row['name']?></td>
                                                        
                                                        
                                                        <th><?= isset($row['size']) ? $row['size'] : '-' ?></th>
                                                        <td><?= $row['quantity']?></td>
                                                        <td>
                                                            <div class="dropdown">
                                                                <button class="btn btn-secondary dropdown-toggle" type="button" data-toggle="dropdown" aria-expanded="false">
                                                                   More
                                                                </button>
                                                                <div class="dropdown-menu">
                                                                    <a class="dropdown-item" data-toggle="modal" data-target="#stock_movein_modal" onclick='movein(<?=json_encode($row)?>,"movein")'>MoveIn</a>
                                                                    <a class="dropdown-item text-danger" data-toggle="modal" data-target="#stock_moveout_modal" onclick='movein(<?=json_encode($row)?>,"moveout")'>MoveOut</a>
                                                                    <a class="dropdown-item" href="stock_edit.php?id=<?php echo $row['id'] ?>">Edit</a>
                                                                    <button class="dropdown-item text-danger" data-toggle="modal" data-target="#cities_delete_modal" onclick="delete_User('<?php echo $row['name']?>','<?php echo $row['id']?>')">Delete</button>
                                                                  
                                                                </div>
                                                            </div>
                                                          
                                                        </td>
                                                        
                                                    </tr>
                                             <?php   }
                                              } else { ?>
                                                    <tr>
                                                        <td colspan="7">No Data</td>
                                                    </tr>
                                           <?php }
                                        ?>
                                       
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Content Row -->
        </div>
        <!-- /.container-fluid -->

    </div>
    <!-- End of Main Content -->
    <?php include('includes/footer.php') ?>
</div>
<!-- End of Content Wrapper -->
</div>

<!-- Modal -->
<div class="modal fade" id="cities_delete_modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Modal title</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body text-center">
            <h6 id="full_name"></h6>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            <a type="button" class="btn btn-secondary" id="delete_user_href">Save changes</a>
        </div>
        </div>
    </div>
</div>

<div class="modal fade" id="stock_movein_modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Stock Move In</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body">
            <form action="api/stock_movein.php" method="post">
                <div class="row">
                    
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Quantity</label>
                            <input type="number" class="form-control" name="quantity" value="0" disabled>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">MoveIn Quantity</label>
                            <input type="number" class="form-control" name="movein_quantity" value="0" min="0">
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Total Available Quantity</label>
                            <input type="number" class="form-control" name="total_available_quantity" value="0" readonly>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Taken By</label>
                            <input type="text" class="form-control" name="taken_by" placeholder="Enter Taken By" required>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Used By</label>
                            <input type="text" class="form-control" name="used_by" placeholder="Enter Used By" required>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col-12 text-right">
                        <input type="hidden" name="stock_id">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary" id="delete_user_href">Save Stock Move In</button>
                    </div>
                </div>
            </form>
        </div>
        
        </div>
    </div>
</div>

<div class="modal fade" id="stock_moveout_modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Stock Move Out</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body">
            <form action="api/stock_moveout.php" method="post">
                <div class="row">
                    
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Quantity</label>
                            <input type="number" class="form-control" name="quantity" value="0" disabled>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">MoveOut Quantity</label>
                            <input type="number" class="form-control" name="moveout_quantity" value="0" min="0">
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Total Available Quantity</label>
                            <input type="number" class="form-control" name="total_available_quantity" value="0" readonly>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Taken By</label>
                            <input type="text" class="form-control" name="taken_by" placeholder="Enter Taken By" required>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Used By</label>
                            <input type="text" class="form-control" name="used_by" placeholder="Enter Used By" required>
                        </div>
                    </div>
                  
                </div>
                <hr>
                <div class="row">
                    <div class="col-12 text-right">
                        <input type="hidden" name="stock_id">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary" id="delete_user_href">Save Stock Move Out</button>
                    </div>
                </div>
            </form>
        </div>
        
        </div>
    </div>
</div>
<!-- Scroll to Top Button-->
<a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
</a>
    <?php 
        include('includes/logout_modal.php');
        include('includes/footer_link.php');
        include('includes/unsetSuccessErrorSession.php');
    ?>
    <!-- Page level custom scripts -->
<script src="js/demo/datatables-demo.js"></script>

<script>
    function movein(data, type){
        if(type === 'movein'){
            $('#stock_movein_modal input[name=serial_number]').val(data.serial_number);
            $('#stock_movein_modal input[name=price]').val(data.price);
            $('#stock_movein_modal input[name=quantity]').val(data.quantity);
            $('#stock_movein_modal input[name=total_available_quantity]').val(data.quantity);    
            $('#stock_movein_modal input[name=stock_id]').val(data.id);  
        }

        if(type === 'moveout'){
            $('#stock_moveout_modal input[name=serial_number]').val(data.serial_number);
            $('#stock_moveout_modal input[name=price]').val(data.price);
            $('#stock_moveout_modal input[name=quantity]').val(data.quantity);
            $('#stock_moveout_modal input[name=total_available_quantity]').val(data.quantity);
            $('#stock_moveout_modal input[name=moveout_quantity]').attr('max', data.quantity);  
            $('#stock_moveout_modal input[name=stock_id]').val(data.id);  
        }
    }

    $('#stock_movein_modal input[name=movein_quantity]').change(function(){
        var total_movein_quantity = $(this).val();
        var quantity =  $('#stock_movein_modal input[name=quantity]').val();
        var price = $('#stock_movein_modal input[name=price]').val();

        $('#stock_movein_modal input[name=total_available_quantity]').val( parseInt(total_movein_quantity) + parseInt(quantity));   
        $('#stock_movein_modal input[name=total_movein_value]').val( (parseInt(total_movein_quantity) * parseFloat(price)).toFixed(2));    
    });

    $('#stock_moveout_modal input[name=moveout_quantity]').change(function(){
        var total_moveout_quantity = $(this).val();
        var quantity =  $('#stock_moveout_modal input[name=quantity]').val();
        var price = $('#stock_moveout_modal input[name=price]').val();

        $('#stock_moveout_modal input[name=total_available_quantity]').val( parseInt(quantity) - parseInt(total_moveout_quantity) );   
        $('#stock_moveout_modal input[name=total_moveout_value]').val( (parseInt(total_moveout_quantity) * parseFloat(price)).toFixed(2));    
    });

    function delete_User(full_name, id) {
        var url = 'api/delete_stock.php?id='+id;
        $('#full_name').text('Are you sure want to delete '+full_name+ ' ?');
        $('#delete_user_href').attr('href', url);
    }
</script>
</body>

</html>