
<?php session_start(); include('includes/database_connect.php');?>
<?php  if($_SESSION['roles'] != 'admin'  ){
    header('location: /stockmanagement/admin/login.php');
}?> 
<!DOCTYPE html>
<html lang="en">
<head>
    <?php 
        include('includes/header.php'); 
        include('includes/displaySuccessErrorSession.php');
    ?>
</head>
<body id="page-top">
      <!-- Page Wrapper -->
  <div id="wrapper">
  <?php include('includes/sidenav.php');  ?>
<!-- Content Wrapper -->
<div id="content-wrapper" class="d-flex flex-column">

    <!-- Main Content -->
    <div id="content">

        <?php include('includes/topnav.php');  ?>
       
        <!-- Begin Page Content -->
        <div class="container-fluid">
            <!-- Page Heading -->
            <div class="d-sm-flex align-items-center justify-content-between mb-4">
                <h1 class="h3 mb-0 text-gray-800"><?= ucfirst($_REQUEST['type'])?></h1>
            </div>
            <!-- Content Row -->
          
            <div class="row">
                <!-- Area Chart -->
                <div class="col-md-12">
                    <div class="card shadow mb-4">
                        <!-- Card Body -->
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 font-weight-bold text-secondary"><?= ucfirst($_REQUEST['type'])?> Details</h6>
                            <a class="btn btn-secondary" href="electrical_add.php?type=<?=$_REQUEST['type']?>">Add <?= ucfirst($_REQUEST['type'])?></a>
                        </div>
                        <div class="card-body">
                        <div class="table-responsive">
                                
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>Item</th>
                                            <th>Serial Number</th>
                                            <th>Name</th>
                                            <th>Model</th>
                                            <th>Date Start</th>
                                            <th>Date Expiry</th>
                                            <th>Status</th>
                                            <th>Remarks</th>
                                            <th>Location</th>
                                            <th style="width: 15%;">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                            $sql = 'select * from electrical where type="'.$_REQUEST['type'].'" order by id desc';
                                            $result = $conn->query($sql);

                                            if ($result->num_rows > 0) {
                                                // output data of each row
                                                $no = 1;
                                                while($row = $result->fetch_assoc()) { ?>
                                                    <tr>
                                                        <td><?=  $no++ ?></td>
                                                        <td><?php echo '<a href="electrical_history.php?id='.$row['id'].'&type='.$_REQUEST['type'].'">'.$row['serial_number'].'</a>' ?></td>
                                                        <td><?php echo '<a href="electrical_history.php?id='.$row['id'].'&type='.$_REQUEST['type'].'">'.$row['name'].'</a>' ?></td>
                                                        <td><?= $row['model']?></td>
                                                        <td><?= $row['date_start']?></td>
                                                        <td><?= $row['date_expiry']?></td>
                                                        <td><?= $row['status'] == 'available' ? '<span class="text-success">'.ucfirst($row['status']).'</span>'  : '<span class="text-danger">'.ucfirst($row['status']).'</span>' ?></td>
                                                        <td><?= $row['remarks']?></td>
                                                        <td><?= $row['location']?></td>
                                                        <td>
                                                            <div class="dropdown">
                                                                <button class="btn btn-secondary dropdown-toggle" type="button" data-toggle="dropdown" aria-expanded="false">
                                                                   More
                                                                </button>
                                                                <div class="dropdown-menu">
                                                                    <?php 
                                                                        if($row['status'] != 'rented'){ ?>
                                                                            <a class="dropdown-item" data-toggle="modal" data-target="#stock_movein_modal" onclick='movein(<?=json_encode($row)?>,"movein")'>Rent</a>
                                                                    <?php } else { ?>
                                                                        <a class="dropdown-item text-success" data-toggle="modal" data-target="#stock_moveout_modal" onclick='movein(<?=json_encode($row)?>,"moveout")'>Make Available</a>
                                                                    <?php } ?>
                                                                    <a class="dropdown-item" href="electrical_edit.php?id=<?php echo $row['id'] ?>&type=<?=$_REQUEST['type']?>">Edit</a>
                                                                    <button class="dropdown-item text-danger" data-toggle="modal" data-target="#cities_delete_modal" onclick="delete_User('<?=$row['name']?>','<?=$row['id']?>', '<?=$row['type']?>')">Delete</button>
                                                                  
                                                                </div>
                                                            </div>
                                                          
                                                        </td>
                                                    </tr>
                                             <?php   }
                                              } else { ?>
                                                    <tr>
                                                        <td colspan="6">No Data</td>
                                                    </tr>
                                           <?php }; ?>
                                       
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Content Row -->
        </div>
        <!-- /.container-fluid -->

    </div>
    <!-- End of Main Content -->
    <?php include('includes/footer.php');?>
</div>
<!-- End of Content Wrapper -->
</div>

<!-- Modal -->
<div class="modal fade" id="cities_delete_modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Modal title</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body text-center">
            <h6 id="full_name"></h6>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            <a type="button" class="btn btn-danger" id="delete_user_href">Delete</a>
        </div>
        </div>
    </div>
</div>

<div class="modal fade" id="stock_movein_modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Rent</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body">
            <form action="api/electrical_movein.php" method="post">
                <div class="row">
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Date Start</label>
                            <input type="date" class="form-control" name="date_start" required>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Date Expiry</label>
                            <input type="date" class="form-control" name="date_expiry" required>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="form-group">
                            <label class="form-label">Location</label>
                            <input type="text" class="form-control" name="location" placeholder="Enter Location" required>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Taken By</label>
                            <input type="text" class="form-control" name="taken_by" placeholder="Enter Taken By" required>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Used By</label>
                            <input type="text" class="form-control" name="used_by" placeholder="Enter Used By" required>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Price Rental</label>
                            <input type="number" class="form-control" name="price_rental" required>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Price By</label>
                            <input type="number" class="form-control" name="price_by" required>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col-12 text-right">
                        <input type="hidden" name="electrical_id">
                        <input type="hidden" name="type" value="<?=$_REQUEST['type']?>">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary" id="delete_user_href">Rent</button>
                    </div>
                </div>
            </form>
        </div>
        
        </div>
    </div>
</div>

<div class="modal fade" id="stock_moveout_modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Available</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body">
            <form action="api/electrical_moveout.php" method="post">
                <div class="row">
                    <div class="col-12 text-center">
                        <h6> Are you sure want to make these <span class="serial_number"></span> available again?</h6>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col-12 text-right">
                        <input type="hidden" name="electrical_id">
                        <input type="hidden" name="type" value="<?=$_REQUEST['type']?>">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-success" id="delete_user_href">Make Available</button>
                    </div>
                </div>
            </form>
        </div>
        
        </div>
    </div>
</div>
<!-- Scroll to Top Button-->
<a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
</a>
<?php 
        include('includes/logout_modal.php');
        include('includes/footer_link.php');
        include('includes/unsetSuccessErrorSession.php');
    ?>
    <!-- Page level custom scripts -->
<script src="js/demo/datatables-demo.js"></script>

<script>
    function movein(data, type){
        $('#stock_movein_modal input[name=electrical_id]').val(data.id);  
        $('#stock_moveout_modal input[name=electrical_id]').val(data.id); 

        if(type == 'moveout'){
            $('span.serial_number').text(data.serial_number);
        }
    }

    function delete_User(full_name, id, type) {
        var url = 'api/delete_electrical.php?id='+id+'&type='+type;
        $('#full_name').text('Are you sure want to delete '+full_name+ ' ?');
        $('#delete_user_href').attr('href', url);
    }
</script>
</body>

</html>