
<?php session_start(); include('includes/database_connect.php');?>
<?php  if($_SESSION['roles'] != 'admin' && $_SESSION['roles'] != 'homeowner'  ){
    header('location: /stockmanagement/admin/login.php');
}?> 
<!DOCTYPE html>
<html lang="en">
<head>
    <?php 
        include('includes/header.php'); 
        include('includes/displaySuccessErrorSession.php');
    ?>
</head>
<body id="page-top">
      <!-- Page Wrapper -->
  <div id="wrapper">
  <?php include('includes/sidenav.php');  ?>
<!-- Content Wrapper -->
<div id="content-wrapper" class="d-flex flex-column">

    <!-- Main Content -->
    <div id="content">

        <?php include('includes/topnav.php');  ?>
       
        <!-- Begin Page Content -->
        <div class="container-fluid">
            <!-- Page Heading -->
            <div class="d-sm-flex align-items-center justify-content-between mb-4">
                <h1 class="h3 mb-0 text-gray-800"><?= ucfirst($_REQUEST['type'])?> History</h1>
                <a class="btn btn-secondary" href="electrical_listing.php?type=<?=$_REQUEST['type']?>">Back </a>
            </div>
            <!-- Content Row -->
          
            <div class="row">
                <!-- Area Chart -->
                <div class="col-md-12">
                    <div class="card shadow mb-4">
                        <!-- Card Body -->
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 font-weight-bold text-secondary"><?= ucfirst($_REQUEST['type'])?> History Details</h6>
                        </div>
                        <div class="card-body">
                        <div class="table-responsive">
                                
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>Date Start</th>
                                            <th>Date Expiry</th>
                                            <th>Location</th>
                                            <th>Taken By</th>
                                            <th>Used By</th>
                                            <th>Price Rental</th>
                                            <th>Price By</th>
                                            <th>Rented At</th>
                                            <th>Available At</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                            $sql = 'select * from electrical_history where electrical_id="'.$_REQUEST['id'].'" order by id desc';
                                            //var_dump($sql);
                                            $result = $conn->query($sql);

                                            if ($result->num_rows > 0) {
                                                // output data of each row
                                                while($row = $result->fetch_assoc()) { ?>
                                                    <tr>
                                                        <td><?= $row['date_start']?></td>
                                                        <td><?= $row['date_expiry']?></td>
                                                        <td><?= $row['location']?></td>
                                                        <td><?= $row['taken_by']?></td>
                                                        <td><?= $row['used_by']?></td>
                                                        <td><?= isset($row['price_rental']) ? 'RM '.$row['price_rental'] : null?></td>
                                                        <td><?= isset($row['price_by']) ? 'RM '.$row['price_by'] : null?></td>
                                                        <td><?= $row['rented_at']?></td>
                                                        <td><?= $row['available_at']?></td>
                                                    </tr>
                                             <?php   }
                                              } else { ?>
                                                    <tr>
                                                        <td colspan="7">No Data</td>
                                                    </tr>
                                           <?php }
                                        ?>
                                       
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Content Row -->
        </div>
        <!-- /.container-fluid -->

    </div>
    <!-- End of Main Content -->
    <?php include('includes/footer.php') ?>
</div>
<!-- End of Content Wrapper -->
</div>

<!-- Scroll to Top Button-->
<a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
</a>
    <?php 
        include('includes/logout_modal.php');
        include('includes/footer_link.php');
        include('includes/unsetSuccessErrorSession.php');
    ?>
    <!-- Page level custom scripts -->
<script src="js/demo/datatables-demo.js"></script>

<script>
    function movein(data, type){
        $('#stock_movein_modal input[name=electrical_id]').val(data.id);  
        $('#stock_moveout_modal input[name=electrical_id]').val(data.id); 

        if(type == 'moveout'){
            $('span.serial_number').text(data.serial_number);
        }
    }

    function delete_User(full_name, id) {
        var url = 'api/delete_electrical.php?id='+id;
        $('#full_name').text('Are you sure want to delete '+full_name+ ' ?');
        $('#delete_user_href').attr('href', url);
    }
</script>
</body>

</html>