<?php session_start(); 
include('includes/database_connect.php'); ?>
<?php  if($_SESSION['roles'] != 'admin' && $_SESSION['roles'] != 'homeowner'  ){
    header('location: /stockmanagement/admin/login.php');
}?> 
<!DOCTYPE html>
<html lang="en">

<head>
    <?php 
        include('includes/header.php'); 
        include('includes/displaySuccessErrorSession.php');
    ?>
</head>
<body id="page-top">
      <!-- Page Wrapper -->
  <div id="wrapper">
  <?php include('includes/sidenav.php');  ?>
<!-- Content Wrapper -->
<div id="content-wrapper" class="d-flex flex-column">
    <!-- Main Content -->
    <div id="content">
        <?php include('includes/topnav.php');  ?>
        <!-- Begin Page Content -->
        <div class="container-fluid">
            <!-- Page Heading -->
            <div class="d-sm-flex align-items-center justify-content-between mb-4">
                <h1 class="h3 mb-0 text-gray-800">Dashboard</h1>
            </div>
            <!-- Content Row -->
            <div class="row">
                <!-- Earnings (Monthly) Card Example -->
                <div class="col-md-3 mb-4">
                    <div class="card border-left-primary shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                        Total Available Stock</div>
                                        <?php
                                            $sql = 'select sum(quantity) as total_available_stock from stocks ';
                                            $result = $conn->query($sql);
                                            $result = $result->fetch_assoc();
                                        ?>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800"><?=$result['total_available_stock'] ?></div>
                                </div>
                                <div class="col-auto">
                                    <i class="fa fa-users fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Earnings (Monthly) Card Example -->
                <div class="col-md-3 mb-4">
                    <div class="card border-left-success shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                        Total Stock Move In</div>

                                        <?php
                                            $sql = 'select sum(quantity) as total_movein_stock from logs where type="move_in" ';
                                            $result = $conn->query($sql);
                                            $result = $result->fetch_assoc();
                                        ?>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800"><?= $result['total_movein_stock'] ?: 0?></div>
                                </div>
                                <div class="col-auto">
                                    <i class="fa fa-home fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Earnings (Monthly) Card Example -->
                <div class="col-md-3 mb-4">
                    <div class="card border-left-danger shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                    Total Stock Move Out</div>
                                    <?php
                                            $sql = 'select sum(quantity) as total_moveout_stock from logs where type="move_out" ';
                                            $result = $conn->query($sql);
                                            $result = $result->fetch_assoc();
                                        ?>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800"><?= $result['total_moveout_stock'] ?: 0?></div>
                                </div>
                                <div class="col-auto">
                                    <i class="fa fa-home fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        
                <!-- Pending Requests Card Example -->
                <div class="col-md-3 mb-4">
                    <div class="card border-left-warning shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                        Total Stock Move Value</div>
                                        <?php
                                            $sql = 'select sum(price) as total_moveout_value from logs ';
                                            $result = $conn->query($sql);
                                            $result = $result->fetch_assoc();
                                        ?>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800"><?= $result['total_moveout_value'] ?: 0?></div>
                                </div>
                                <div class="col-auto">
                                    <i class="fa fa-globe fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="card border-left-primary shadow h-100 py-2">
                        <div class="card-body">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 font-weight-bold text-primary">Stock Move History Chart</h6>
                        </div>
                        <div style="height:28rem">
                            <canvas id="myChart" class="chartjs-render-monitor"></canvas>
                        </div>

                            <?php 
                                $sql = 'select date(created_at), type, quantity from logs order by id desc';
                                $result = $conn->query($sql);
                                $result = $result->fetch_all();

                                $moveInData = [];
                                $moveOutData = [];
                                foreach ($result as $row) {
                                    if ($row[1] == 'move_in') {
                                        $moveInData[$row[0]] =  (isset($moveInData[$row[0]]) ? $moveInData[$row[0]] :  0) + $row[2];
                                        // If move-out data doesn't exist for this date, add 0
                                        if (!isset($moveOutData[$row[0]])) {
                                            $moveOutData[$row[0]] = 0;
                                        }
                                    } else {
                                        $moveOutData[$row[0]] = (isset($moveOutData[$row[0]]) ? $moveOutData[$row[0]] :  0) + $row[2];
                                        // If move-in data doesn't exist for this date, add 0
                                        if (!isset($moveInData[$row[0]])) {
                                            $moveInData[$row[0]] = 0;
                                        }
                                    }
                                }

                                // Sort the data by date
                                ksort($moveInData);
                                ksort($moveOutData);

                                $chartData = [
                                    'labels' => array_keys($moveInData),
                                    'datasets' => [
                                        [
                                            'label' => 'stock movein',
                                            'data' => array_values($moveInData),
                                            'backgroundColor' => 'rgba(255, 99, 132, 0.2)',
                                            'borderColor' => 'rgba(255, 99, 132, 1)',
                                            'borderWidth' => 1
                                        ],
                                        [
                                            'label' => 'stock moveout',
                                            'data' => array_values($moveOutData),
                                            'backgroundColor' => 'rgba(54, 162, 235, 0.2)',
                                            'borderColor' => 'rgba(54, 162, 235, 1)',
                                            'borderWidth' => 1
                                        ]
                                    ]
                                ];

                                $encode_chartData =  json_encode($chartData)
                            ?>
                       
                        </div>
                    </div>
               
                </div>
            </div>
            
             <!-- Content Row -->
        </div>
        <!-- /.container-fluid -->

    </div>
    <!-- End of Main Content -->

    <?php include('includes/footer.php') ?>

</div>
<!-- End of Content Wrapper -->

</div>

<!-- End of Page Wrapper -->

<!-- Scroll to Top Button-->
<a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
</a>
    <?php 
        include('includes/logout_modal.php');
        include('includes/footer_link.php');
        include('includes/unsetSuccessErrorSession.php');
    ?>
</body>

<script>
    // Set new default font family and font color to mimic Bootstrap's default styling
Chart.defaults.global.defaultFontFamily = 'Nunito', '-apple-system,system-ui,BlinkMacSystemFont,"Segoe UI",Roboto,"Helvetica Neue",Arial,sans-serif';
Chart.defaults.global.defaultFontColor = '#858796';

// Area Chart Example
var ctx = document.getElementById("myChart");

const config = {
  type: 'line',
  data: <?=$encode_chartData?>,
  options: {
    maintainAspectRatio: false,
    plugins: {
      filler: {
        propagate: false,
      },
      title: {
        display: true,
        text: (ctx) => 'Fill: ' + ctx.chart.data.datasets[0].fill
      }
    },
    interaction: {
      intersect: false,
    }
  },
};



new Chart(ctx, config);

</script>
</html>